import serial
import ftplib
import subprocess
import os
import shutil
from manejadorBD import ejecutarQuery
from gpiozero import Buzzer
import enviosftp
import time
import socket
import sys
from threading import Thread

import procesos

#Actualizar Tabla de Configuracion
ADULTO = '01'
ESTUDIANTE = '02'
INSEN = '03'
OTRO = '04'
BARRA_1_LOG = '05'
BARRA_2_LOG = '06'
NOMBRE_RUTA = '07'
TIEMPO_IGNICION_APAGADO = '08'
TIPO_IGNICION_APAGADO = '09'

serieAdulto             = ""
serieEstudiante         = ""
serieInsen              = ""
serieOtro               = ""
precioAdulto            = ""
precioEstudiante        = ""
precioInsen             = ""
precioOtro              = ""
nombreRuta              = ""
barra1Log               = 0
barra2Log               = 0
tipoApagado             = 0
tiempoApagado           = ""

enviandoGPS = False


pinResetGeneral   = Buzzer(25) #Reset General
pinResetRaspberry    = Buzzer(8)  #Reset Barra1
pinResetBarra1    = Buzzer(7)  #Reset Barra2
pinResetBarra2  = Buzzer(1)  #Reset Barra1 y Barra2

try:
    serControlador = serial.Serial(
        port='/dev/ttyS0',
        baudrate=9600,
        parity=serial.PARITY_NONE,
        stopbits=serial.STOPBITS_ONE,
        bytesize=serial.EIGHTBITS,
        timeout=1
    )
except:
    print('Error')

def ls(ruta = os.getcwd()):
    return [arch.name for arch in os.scandir(ruta) if arch.is_file()]

def enviarGPS(intentos, cadena, tipo, deleteQr = '', deleteQr2 = ''):
    global enviandoGPS

    if not enviandoGPS:
        enviandoGPS = True
    else:
        while enviandoGPS:
            time.sleep(1.5)
            enviandoGPS = True
            break

    try:
        tipostr = ''
        if tipo == 0:    
            tipostr = 'Barras'
        if tipo == 1:
            tipostr = 'Boletos'
        if tipo == 2:
            tipostr = 'Cortes'
        if tipo == 3:
            tipostr = 'Eventos'
        
        print('Enviando al GPS. Tipo: ' + tipostr)
        procesos.escribirLogGeneral('Enviando al GPS. Tipo: ' + tipostr)
        print('Cadena:' + cadena)
        procesos.escribirLogGeneral('Cadena:' + cadena)
        cadenaStr = str(cadena + "\n")
        serGPS= serial.Serial(
            port='/dev/gps0',
            baudrate=115200,
            parity=serial.PARITY_NONE,
            stopbits=serial.STOPBITS_ONE,
            bytesize=serial.EIGHTBITS,
            timeout=30
        )
        time.sleep(2)
        serGPS.write(cadenaStr.encode())
        time.sleep(2)
        serGPS.close()

        enviandoGPS = False
        
        ejecutarQuery(deleteQr)
        ejecutarQuery(deleteQr2)
    except Exception:
        print("INTENTOS: "+str(intentos))
        intentos += 1
        if intentos < 5:
            t = Thread(target=enviarGPS, args=(intentos, cadena, tipo, deleteQr, deleteQr2))
            t.start()
        else:
            print('No se puede enviar al GPS')
            procesos.escribirLogGeneral('No se puede enviar al GPS')

def actualizarConfig(opcion, valor):
    query = ''
    if opcion == ADULTO:
        query = "UPDATE configuracion SET precioAdulto = '" + valor + "'"
        global precioAdulto
        precioAdulto = valor
    if opcion == ESTUDIANTE:
        query = "UPDATE configuracion SET precioEstudiante = '" + valor + "'"
        global precioEstudiante
        precioEstudiante = valor
    if opcion == INSEN:
        query = "UPDATE configuracion SET precioInsen = '" + valor + "'"
        global precioInsen
        precioInsen = valor
    if opcion == OTRO:
        query = "UPDATE configuracion SET precioOtro = '" + valor + "'"
        global precioOtro
        precioOtro = valor
    if opcion == BARRA_1_LOG:
        query = "UPDATE configuracion SET barra1Log = '" + valor + "'"
        global barra1Log
        barra1Log = int(valor)
    if opcion == BARRA_2_LOG:
        query = "UPDATE configuracion SET barra2Log = '" + valor + "'"
        global barra2Log
        barra2Log = int(valor)
    if opcion == NOMBRE_RUTA:
        query = "UPDATE configuracion SET nombreRuta = '" + valor + "'"
        global nombreRuta
        nombreRuta = valor
    if opcion == TIEMPO_IGNICION_APAGADO:
        if TIPO_IGNICION_APAGADO == 0:
            valor = '1440'
        query = "UPDATE configuracion SET tiempoApagado = '" + valor + "'"
        global tiempoApagado
        tiempoApagado = valor
        print(query)
        ser.write('delayIgniOFF {}'.format(tiempoApagado).encode())
    if opcion == TIPO_IGNICION_APAGADO:
        query = "UPDATE configuracion SET tipoApagado = '" + valor + "'"
        global tipoApagado
        tipoApagado = int(tipoApagado)
        if tipoApagado == 0:
            tiempoApagado = '1440'
            ser.write('delayIgniOFF {}'.format(tiempoApagado).encode())
    ejecutarQuery(query)
    mensaje = '!|04'
    enviarGPS(0, mensaje, 3)
    
def moverArchivos(origen, destino):
    shutil.copy(origen, destino)

def cambiarWiFi(essid, clave):
    sbps = subprocess.Popen(['sudo', 'chmod', '777', '/etc/wpa_supplicant/wpa_supplicant.conf'], stdout = subprocess.PIPE, stderr = subprocess.STDOUT)
    
    time.sleep(1)

    #config = 'auto wlan0\niface wlan0 inet dhcp\nwireless-essid "' + essid + '"\nwireless-key "' + clave + '"'
    config = 'ctrl_interface=DIR=/var/run/wpa_supplicant GROUP=netdev\nupdate_config=0\ncountry=MX\nnetwork={\nssid="' + essid + '"\npsk="' + clave + '"\nkey_mgmt=WPA-PSK\n}'
    
    file = open('/etc/wpa_supplicant/wpa_supplicant.conf', 'w')
    file.write(config)

    time.sleep(0.2)

    #sbps = subprocess.Popen(['sudo', 'ip', 'link', 'set', 'wlan0', 'up'], stdout = subprocess.PIPE, stderr = subprocess.STDOUT)
    sbps = subprocess.Popen(['sudo', 'wpa_cli', '-i', 'wlan0', 'reconfigure'], stdout = subprocess.PIPE, stderr = subprocess.STDOUT) 
    
    print('WIFI actualizado {}'.format(essid))
    procesos.escribirLogGeneral('WIFI actualizado {}'.format(essid))

def actualizarFW(nuevaVersion, rutaEnServidor):
    s = socket.socket()
    s.connect(('localhost', 9999))

    pid = os.getpid()

    datos = str(pid) + '|' + nuevaVersion + '|' + rutaEnServidor

    s.send((bytes(datos, 'utf-8')))
    s.close()

def actualizarFechaHora():
    sbps = subprocess.Popen(['sudo', 'ntpd', '-gq'], stdout = subprocess.PIPE, stderr = subprocess.STDOUT) 
    time.sleep(1)
    sbps = subprocess.Popen(['sudo', '/etc/init.d/ntp', 'restart'], stdout = subprocess.PIPE, stderr = subprocess.STDOUT)

def verificarInternet():
    comando = ''
    #ps = subprocess.Popen(['iwgetid'], stdout=subprocess.PIPE, stderr = subprocess.STDOUT)
    con = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        con.connect(('www.google.com', 80))
        con.close()

        sbps = subprocess.Popen(['cat', '/proc/net/wireless'], stdout = subprocess.PIPE, stderr = subprocess.STDOUT)
        salida = sbps.stdout.read().decode()
        strwlan = salida.find('wlan0')
        datos = salida[strwlan:]
        intensidad = datos.split()[2].replace('.','')
        
        comando = '!|05|ON{}'.format(intensidad)
        enviarGPS(0, comando, 3)

        #output = subprocess.check_output(('grep', 'ESSID'), stdin=ps.stdout)
        #print('Hay conexion Wifi')
    except:
        comando = '!|05|OFF'
        enviarGPS(0, comando, 3)
        con.close()

def obtenerFechaHora():
    sbps = subprocess.Popen(['date'], stdout = subprocess.PIPE, stderr = subprocess.STDOUT)

    salida = sbps.stdout.read().decode()

    comando = '!|08|{}'.format(salida)

    enviarGPS(0, comando, 3)


def escuchaGPS(ser):
    while True:
        try:
            cadena = ser.readline().decode()
        except:
            print('Error al leer el serial del GPS')
            cadena = ''
        if len(cadena) > 2:
            try:
                print(cadena)
                procesos.escribirLogGeneral('Comando GPS Recibido: {}'.format(cadena))
                fragmentos = cadena.split('|')
                if fragmentos[0] == '#':
                    tipoComando = fragmentos[1]
                    if tipoComando[0:2] == '01':
                        opcion = tipoComando[2:4]
                        valor = fragmentos[2]
                        valor = valor.replace('*', '')
                        actualizarConfig(opcion, valor)
                    if tipoComando[0:2] == '02':
                        opcion = tipoComando[2:]
                        if opcion == '01':
                            origen = os.getcwd() + "/_logs/logsbarra1/B1" + procesos.obtenerfecha(4) + ".txt"
                            destino = os.getcwd() + "/pendientes/B1" + procesos.obtenerfecha(0) + ".txt"
                            moverArchivos(origen, destino)
                        if opcion == '02':
                            origen = os.getcwd() + "/_logs/logsbarra2/B2" + procesos.obtenerfecha(4) + ".txt"
                            destino = os.getcwd() + "/pendientes/B2" + procesos.obtenerfecha(0) + ".txt"
                            moverArchivos(origen, destino)
                        if opcion == '03':
                            origen = os.getcwd() + "/_logs/general/" + procesos.obtenerfecha(4) + ".txt"
                            destino = os.getcwd() + "/pendientes/G" + procesos.obtenerfecha(0) + ".txt"
                            moverArchivos(origen, destino)
                        if opcion == '04':
                            origen = os.getcwd() + "prueba.db"
                            destino = os.getcwd() + "/pendientes/prueba" + procesos.obtenerfecha(0) + ".db"
                            moverArchivos(origen, destino)
                        if opcion == '05':
                            pathfoto = os.getcwd() + '/pendientes/' + procesos.obtenerfecha(0) + '.png'
                            procesos.imagenesEspera1.append((pathfoto, 'Solicitada', 1))
                        if opcion == '06':
                            pathfoto = os.getcwd() + '/pendientes/' + procesos.obtenerfecha(0) + '.png'
                            procesos.imagenesEspera2.append((pathfoto, 'Solicitada', 2))
                    if tipoComando[0:2] == '03':
                        opcion = tipoComando[2:]
                        if opcion == "01":
                            #reset general
                            pinResetGeneral.beep(1, 1, 1, True)
                        if opcion == "02":
                            #reset Raspberry
                            serControlador.write('resetRB'.encode())
                        if opcion == "03":
                            #reset Barra1
                            pinResetBarra1.beep(2, 1, 1, True)
                        if opcion == "04":
                            #reset Barra2
                            pinResetBarra2.beep(2, 1, 1, True)
                        if opcion == '05':
                            comandoApagado = '!|03'
                            enviarGPS(0, comandoApagado, 3)

                            time.sleep(1)
                            sbps = subprocess.Popen(['sudo', 'reboot'], stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
                    if tipoComando[0:2] == "04":
                        #Actualizar de Firmware
                        opcion = tipoComando[2:4]
                        if opcion == '01':
                            nuevaVersion = fragmentos[2]
                            rutaEnServidor = fragmentos[3]

                            actualizarFW(nuevaVersion, rutaEnServidor)
                        if opcion == '02':
                            essid = fragmentos[2]
                            clave = fragmentos[3]
                            cambiarWiFi(essid, clave)
                        if opcion == '03':
                            actualizarFechaHora()
                    if tipoComando[0:2] == '05':
                        opcion = tipoComando[2:4]

                        if opcion == '01':
                            sub_opcion = tipoComando[4:]
                            raiz_archivos = ''
                            if sub_opcion == '01':
                                raiz_archivos = 'fotos/barras'
                            if sub_opcion == '02':
                                raiz_archivos = 'fotos/boletos'
                            if sub_opcion == '03':
                                raiz_archivos = 'fotos/cortes'
                            if sub_opcion == '04':
                                raiz_archivos = 'pendientes'
                            archivos = ls(raiz_archivos)
                            comando = '!|01{}|{}'.format(sub_opcion, len(archivos))
                            
                            enviarGPS(0, comando, 3)
                        if opcion == '02':
                            verificarInternet()
                        if opcion == '03':
                            config = '{},{},{},{},{},{},{},{},{},{},{},{},{}'.format(serieAdulto, serieEstudiante, serieInsen, serieOtro, precioAdulto, precioEstudiante, precioInsen, precioOtro, nombreRuta, barra1Log, barra2Log, tipoApagado, tiempoApagado)
                            comando = '!|06|{}'.format(config)
                            enviarGPS(0, comando, 3)
                        if opcion == '04':
                            obtenerFechaHora()

                    if tipoComando[0:2] == '10':
                        opcion = tipoComando[2:]
                        if opcion == '01':
                            print('Cerrando sistema barras')
                            comandoApagado = '!|03'
                            enviarGPS(0, comandoApagado, 3)
                            time.sleep(1)
                            pid = os.getpid()

                            sbps = subprocess.Popen(['sudo kill {}'.format(pid)], shell=True)
                        if opcion == '02':
                            mensaje = fragmentos[2]
                            
                            sbps = subprocess.Popen("sudo echo -e \"" + str(mensaje) + "\" > /dev/usb/lp0", shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                            err = sbps.stderr.read().decode()

                            comando = ''
                            if err != '':
                                comando = '!|07'
                            else:
                                comando = '!|04'
                            enviarGPS(0, comando, 3)


            except Exception as ex:
                print('Formato de comando no valido: ' + str(ex))

def escuchaControlador():
    time.sleep(1.5)
    serControlador.write('delayIgniOFF {}'.format(tiempoApagado).encode())
    while True:
        try:
            cc = serControlador.readline().decode()
        except:
            print('Error al leer el serial del controlador')
            cc = ''
        if cc != '':
            print(cc)
            if 'rb_shutdown' in cc:
                comandoApagado = '!|03'
                enviarGPS(0, comandoApagado, 3)

                time.sleep(1)

                sbps = subprocess.Popen(['sudo', 'shutdown', '-h', 'now'], stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            if 'rb_delayIgniOFF' in cc:
                serControlador.write('delayIgniOFF {}'.format(tiempoApagado).encode())
