#FTP
import ftplib
import subprocess
import os
from datetime import datetime, timedelta

enviandoFBarras = False
enviandoFBoletos = False
enviandoFCortes = False
enviandoPendientes = False

def ls(ruta = os.getcwd()):
    return [arch.name for arch in os.scandir(ruta) if arch.is_file()]

def obtenerfecha(t):
    if t == 0:
        return datetime.now().strftime("%y%m%d%H%M%S%f")
    if t == 1:
        return datetime.now().strftime("%d/%m/%Y")
    if t == 2:
        return datetime.now().strftime("%d/%m/%Y %H:%M:%S")
    if t == 3:
        return datetime.now().strftime("%y%m%d%H%M%S")
    if t == 4:
        return datetime.now().strftime("%d_%m_%Y")
    if t == 5:#Retorna fecha de ayer. 
        return (datetime.now() - timedelta(1)).strftime('%d_%m_%Y')
    if t == 6:#Retorna fecha de ayer con el formato de la opcion 0
        return (datetime.now() - timedelta(1)).strftime("%y%m%d%H%M%S%f")

def enviarFTP(tipo):
    global enviandoFBarras
    global enviandoFBoletos
    global enviandoFCortes
    global enviandoPendientes
    
    ftp_servidor = '72.55.140.5'
    ftp_usuario = 'sensorbarras@redurbana.com.mx'
    #ftp_clave = 'Sensor1234'
    ftp_clave = 'Sensor1234'
    ftp_raiz = ''
    
    raiz_archivos = ''
    if tipo == -1:
        raiz_archivos = 'pendientes'
    if tipo == 0:
        ftp_raiz = 'fotos/barras'
        raiz_archivos = 'fotos/barras'
    if tipo == 1:
        ftp_raiz = 'fotos/boletos'
        raiz_archivos = 'fotos/boletos'
    if tipo == 2:
        ftp_raiz = 'fotos/cortes'
        raiz_archivos = 'fotos/cortes'
    if tipo == 3:
        ftp_raiz = '_logs/logsbarra1'
        raiz_archivos = '_logs/logsbarra1'
        nombreArchivo = 'B1' + obtenerfecha(4) + str(".txt")
        nombreArchivoAyer = 'B1' + obtenerfecha(5) + str(".txt")
    if tipo == 4:
        ftp_raiz = '_logs/logsbarra2'
        raiz_archivos = '_logs/logsbarra2'
        nombreArchivo = 'B2' + obtenerfecha(4) + str(".txt")
        nombreArchivoAyer = 'B2' + obtenerfecha(5) + str(".txt")

    archivos = ls(raiz_archivos)

    if len(archivos) == 0:
        print('No hay archivos para enviar en {}'.format(raiz_archivos))
        nada=0
    else:
        cont = 0
        print('Enviando {} fotos en {}'.format(len(archivos), raiz_archivos))
        for x in range(len(archivos)):
            if tipo < 3 or (archivos[x] == nombreArchivo or archivos[x] == nombreArchivoAyer):
                try:
                    s = ftplib.FTP_TLS(ftp_servidor, ftp_usuario, ftp_clave, timeout=15)
                    try:
                        if tipo == -1:
                            if archivos[x][0:2] == 'B1':
                                ftp_raiz = '_logs/logsbarra1'
                            elif archivos[x][0:2] == 'B2':
                                ftp_raiz = '_logs/logsbarra1'
                            else:
                                ftp_raiz = 'fotos/solicitadas'
                            
                        #print('archivos/boletos/{}'.format(archivos[x]))
                        #print(raiz_archivos + '/{}'.format(archivos[x]))
                        f = open(raiz_archivos + '/{}'.format(archivos[x]), 'rb')
                        s.cwd(ftp_raiz)
                        s.storbinary('STOR ' + archivos[x], f)
                        f.close()
                        s.quit()
                        if tipo < 3:
                            os.remove(raiz_archivos + '/{}'.format(archivos[x]))
                        cont += 1
                    except Exception as e:
                        print('No se ha podido encontrar el fichero/' + archivos[x] + " error: " + str(e))
                        s.quit()
                except ftplib.all_errors as e:
                    print('No se ha podido conectar al servidor ' + ftp_servidor)
                    print(e)
        print('Se enviaron {} fotos'.format(cont))
    if tipo == -1:
        enviandoPendientes = False
    if tipo == 0:
        enviandoFBarras = False
    if tipo == 1:
        enviandoFBoletos = False
    if tipo == 2:
        enviandoFCortes = False