# encoding: utf-8
import os
import errno
import serial
import sqlite3
from sqlite3 import Error
from datetime import datetime, timedelta
from threading import Timer
from threading import Thread
import socket
import time
from manejadorBD import ejecutarQuery
#Botones
#import RPi.GPIO as GPIO
from gpiozero import Button
from gpiozero import Buzzer
from signal import pause
import numpy as np
import cv2
#camera
from picamera import PiCamera
from time import sleep

#FTP
import ftplib
import subprocess

import enviosftp
import comandosGPS

btn6 = Button(6)
btn13 = Button(13)
btn19 = Button(19)
btn26 = Button(26)
buzzer = Buzzer(21) #Buzzer

#pinResetGeneral   = Buzzer(25) #Reset General
#pinResetBarra1    = Buzzer(8)  #Reset Barra1
#pinResetBarra2    = Buzzer(7)  #Reset Barra2
#pinResetBarra1y2  = Buzzer(1)  #Reset Barra1 y Barra2

#192.168.1.76
host_server = '187.153.95.215'
port_server = 7078 #7078
#puerto_serial = '/dev/ttyUSB1'
puerto_serial_ard1 = '/dev/arduino1'
puerto_serial_ard2 = '/dev/arduino2'
baud_rate = 57600

#(pathfoto, categoria, posicion)
imagenesEspera1 = []
imagenesEspera2 = []

#Configuracion Enviar GPS
try:
    ser= serial.Serial(
        port='/dev/gps0',
        baudrate=115200,
        parity=serial.PARITY_NONE,
        stopbits=serial.STOPBITS_ONE,
        bytesize=serial.EIGHTBITS,
        timeout=1
    )
    time.sleep(1.5)
except:
    print('Error al conectar con el GPS')

'''
def ejecutarQuery(query, datos = None):
    con = sqlite3.connect('prueba.db')
    cursorObj = con.cursor()
    if datos != None:
        cursorObj.execute(str(query), datos)
    else:
        cursorObj.execute(str(query))
    rows = cursorObj.fetchall()
    con.commit()
    return rows
'''
try:
    os.mkdir('fotos')
except OSError as e:
    if e.errno != errno.EEXIST:
        raise
    
try:
    os.mkdir('_logs')
except OSError as e:
    if e.errno != errno.EEXIST:
        raise
    
try:
    os.mkdir('pendientes')
except OSError as e:
    if e.errno != errno.EEXIST:
        raise

try:
    os.mkdir('_logs/logsbarra1')
except OSError as e:
    if e.errno != errno.EEXIST:
        raise

try:
    os.mkdir('_logs/logsbarra2')
except OSError as e:
    if e.errno != errno.EEXIST:
        raise

try:
    os.mkdir('fotos/barras')
except OSError as e:
    if e.errno != errno.EEXIST:
        raise
    
try:
    os.mkdir('fotos/boletos')
except OSError as e:
    if e.errno != errno.EEXIST:
        raise
    
try:
    os.mkdir('fotos/cortes')
except OSError as e:
    if e.errno != errno.EEXIST:
        raise

try:
    ejecutarQuery('CREATE TABLE IF NOT EXISTS "eventos" ("id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,"tipoEvento" INTEGER,"fecha" TEXT,"duracion" INTEGER,"posicion" INTEGER,"foto" TEXT DEFAULT \'\')')
    ejecutarQuery('CREATE TABLE IF NOT EXISTS "barrascorte" ("id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,"tipoEvento" INTEGER,"fecha" TEXT,"duracion" INTEGER,"posicion" INTEGER,"foto" TEXT DEFAULT \'\')')
    ejecutarQuery('CREATE TABLE IF NOT EXISTS totalespasaje (id INTEGER PRIMARY KEY AUTOINCREMENT,totalsu INTEGER,totalba INTEGER,totalbl INTEGER,totalot INTEGER, totaladultos INTEGER, totalestudiantes INTEGER, totalinsen INTEGER, totalotro INTEGER)')
    ejecutarQuery('CREATE TABLE IF NOT EXISTS "boletos" ("folio" INTEGER, "fecha" TEXT, "tipo" TEXT, "foto" TEXT DEFAULT\'\')')
    ejecutarQuery('CREATE TABLE IF NOT EXISTS "bolcorte" ("folio" INTEGER, "fecha" TEXT, "tipo" TEXT, "foto" TEXT DEFAULT\'\')')
    ejecutarQuery('CREATE TABLE IF NOT EXISTS "configremoto" ("host" TEXT, "user" TEXT, "password" TEXT, "ccl" TEXT DEFAULT\'\')')
    ejecutarQuery('CREATE TABLE IF NOT EXISTS "configuracion" ("serieAdulto" TEXT, "serieEstudiante" TEXT, "serieInsen" TEXT, "serieOtro" TEXT, "precioAdulto" TEXT, "precioEstudiante" TEXT, "precioInsen" TEXT, "precioOtro" TEXT, "nombreRuta" TEXT, "barra1Log" TEXT, "barra2Log" TEXT, "transmitir" TEXT, "tipoApagado" INTEGER, "tiempoApagado" TEXT \'\')')
    ejecutarQuery('INSERT INTO configuracion(serieAdulto, serieEstudiante, serieInsen, serieOtro, precioAdulto, precioEstudiante, precioInsen, precioOtro, nombreRuta, barra1Log, barra2Log, transmitir, tipoApagado, tiempoApagado) SELECT \'AA\', \'BA\', \'CA\', \'DA\', 9, 6, 6, 6, \'Red Urbana\', 1, 1, 1, 1, \'120\'  WHERE NOT EXISTS(SELECT 1 FROM configuracion WHERE serieAdulto = \'AA\');')
    
    
    #Precios y Series de Folios
    config = ejecutarQuery("SELECT serieAdulto, serieEstudiante, serieInsen, serieOtro, precioAdulto, precioEstudiante, precioInsen, precioOtro, nombreRuta, barra1Log, barra2Log, transmitir, tipoApagado, tiempoApagado FROM configuracion")
    comandosGPS.serieAdulto             = config[0][0]
    comandosGPS.serieEstudiante         = config[0][1]
    comandosGPS.serieInsen              = config[0][2]
    comandosGPS.serieOtro               = config[0][3]
    comandosGPS.precioAdulto            = config[0][4]
    comandosGPS.precioEstudiante        = config[0][5]
    comandosGPS.precioInsen             = config[0][6]
    comandosGPS.precioOtro              = config[0][7]
    comandosGPS.nombreRuta              = config[0][8]
    comandosGPS.barra1Log               = int(config[0][9])
    comandosGPS.barra2Log               = int(config[0][10])
    transmitir                          = config[0][11]
    comandosGPS.tipoApagado             = int(config[0][12])
    comandosGPS.tiempoApagado           = config[0][13]
    row = ejecutarQuery('SELECT COUNT(*) FROM totalespasaje')
    if row[0][0] == 0:
        ejecutarQuery('INSERT INTO totalespasaje(totalsu, totalba, totalbl, totalot, totaladultos, totalestudiantes, totalinsen, totalotro) VALUES(0,0,0,0,0,0,0,0)')
except Error as e:
    print(e)

def ls(ruta = os.getcwd()):
    return [arch.name for arch in os.scandir(ruta) if arch.is_file()]
    

def escribirLog(cc) :
    pos = cc[0:1]
    raiz = ""
    
    fecha = str(obtenerfecha(4))
    if pos == '1':
        raiz = str("_logs/logsbarra1/B1")
    if pos == '2':
        raiz = str("_logs/logsbarra2/B2")
        
    if (pos == '1' and comandosGPS.barra1Log == 1) or (pos == '2' and comandosGPS.barra2Log == 1):
        nombreArchivo = raiz + fecha + str(".txt")
        archivo = open(nombreArchivo, "a")
        archivo.write(obtenerfecha(2) + str(">> " )+ str(cc) + "\n")
        archivo.close()

def eliminarLogs():
    raiz_logs = ""
    if comandosGPS.barra1Log == 0:
        raiz_logs = str("_logs/logBarra1/")
    if comandosGPS.barra2Log == 0:
        raiz_logs = str("_logs/logBarra2/")
    logstxt = ls(raiz_logs)
    if len(logstxt) == 0:
        nada=0
    else:
        for x in range(len(logstxt)):
            if not logstxt[x] in str(obtenerfecha(4)) + str(".txt"):
                os.remove(raiz_logs + logstxt[x])

wifiON = False

def verificarWifi():
    global wifiON
    print('Verificando conexion a internet...')
    t_w = Timer(30.0, verificarWifi)
    t_w.start()
    
    #ps = subprocess.Popen(['iwgetid'], stdout=subprocess.PIPE, stderr = subprocess.STDOUT)
    con = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        con.connect(('www.google.com', 80))
        #output = subprocess.check_output(('grep', 'ESSID'), stdin=ps.stdout)
        #print('Hay conexion Wifi')

        if not enviosftp.enviandoPendientes:
            enviosftp.enviandoPendientes = True
            t = Thread(target=enviosftp.enviarFTP, args=(-1, ))
            t.start()
        if not enviosftp.enviandoFBarras:
            enviosftp.enviandoFBarras = True
            t = Thread(target=enviosftp.enviarFTP, args=(0, ))
            t.start()
        if not enviosftp.enviandoFBoletos:
            enviosftp.enviandoFBoletos = True
            t = Thread(target=enviosftp.enviarFTP, args=(1, ))
            t.start()
        if not enviosftp.enviandoFCortes:
            enviosftp.enviandoFCortes = True
            t = Thread(target=enviosftp.enviarFTP, args=(2, ))
            t.start()
        if not wifiON:
            print('Internet ON')
            wifiON = True
        return True
    except:
        if wifiON:
            print('Internet OFF')
            wifiON = False
        return False
    

def servidorDisponible():
    s = socket.socket()
    #s.connect(('192.168.1.87', 6030))
    try:
        s.connect((host_server, port_server))
        s.close()
        return True
    except Exception:
        s.close()
        return False

def enviarTCPBoletos(var):
    rows = ejecutarQuery("SELECT fecha, tipo, folio, foto FROM boletos")
    if len(rows) > 0:
        print("Enviando Boletos TCP")
        cadena = '#|'
        separador = '|'
        deleteQr = ''
        deleteQr = 'DELETE FROM boletos WHERE folio in ('
        for x in range(len(rows)):
            cadena += '{},{},{},{}{}'.format(rows[x][0], rows[x][1], rows[x][2], rows[x][3], separador)
            #deleteQr += "DELETE FROM boletos WHERE folio = '" + str(rows[x][2]) + "'; "
            deleteQr += "'" + str(rows[x][2]) + "',"
        deleteQr = deleteQr[:-1]
        deleteQr += ")"
        rowsTot = ejecutarQuery("SELECT totalsu, totalba, totalbl, totalot FROM totalespasaje")
        cadena += '{},{},{},{}*'.format(rowsTot[0][0], rowsTot[0][1], rowsTot[0][2], rowsTot[0][3])
        #comando = 'ST300UEX;907522797;01;010;20200218;17:41:56;2F100;+22.257101;-97.855511;000.012;000.00;9;1;0;15.30;001100;25;{};12;0;4.5;1'.format(cadena)
        comando = cadena
        try:
            t = Thread(target=comandosGPS.enviarGPS, args=(0,comando,1,deleteQr))
            t.start()
            #print(deleteQr)
        except:
            print("Error al enviar boletos via TCP")
    t_enviarTCPBoletos = Timer(30.0, enviarTCPBoletos, (True,))
    t_enviarTCPBoletos.start()

def vaciarTabla(repetir, idEventos):
    #print('Vaciando tabla Eventos ====================== {}'.format(repetir))
    if repetir:
        #print("Vaciado de Eventos al Minuto")
        t = Timer(30.0, vaciarTabla, (True,0))
        t.start()
        rows = ejecutarQuery('SELECT MIN(id), MAX(id) FROM eventos')
        idEventosMin = rows[0][0]
        idEventosMax = rows[0][1]
    #con = sqlite3.connect('prueba.db')
    if repetir:
        rows = ejecutarQuery('SELECT fecha,posicion,tipoEvento,duracion,foto, id FROM eventos WHERE id <= ? AND id >= ?', (idEventosMax, idEventosMin))
    else:
        rows =  ejecutarQuery('SELECT fecha,posicion,tipoEvento,duracion,foto, id FROM eventos WHERE id <= ? AND id >= ?', (idEventos[1], idEventos[0]))
    
    if len(rows) > 0:
        cadena = '@|'
        separador = '|'
        cont = 1
        for x in range(len(rows)):
            #print('cont {} ------------------'.format(cont))
            if cont == 1:
                cadena = '@|'
                idPrimero = rows[x][5]

            cadena += '{},{},{},{},{}{}'.format(rows[x][0], rows[x][1], rows[x][2], rows[x][3], rows[x][4], separador)
            
            if cont == 5 or (x == len(rows) - 1):
                #print('5 registros---------------')
                idUltimo = rows[x][5]            
                rowsTotales = ejecutarQuery('SELECT totalsu,totalba,totalbl,totalot FROM totalespasaje')
                cadena += '{},{},{},{}*'.format(rowsTotales[0][0], rowsTotales[0][1], rowsTotales[0][2], rowsTotales[0][3])
                print(cadena)
                #comando = 'ST300UEX;907522797;01;010;20200218;17:41:56;2F100;+22.257101;-97.855511;000.012;000.00;9;1;0;15.30;001100;25;{};12;0;4.5;1'.format(cadena)
                comando = cadena
                deleteQr = 'DELETE FROM eventos WHERE id >= {} AND id <= {}'.format(idPrimero, idUltimo)
                #if servidorDisponible():
                    #print('Servidor Disponible')
                comandosGPS.enviarGPS(0, comando, 0, deleteQr=deleteQr)
                cont = 1
            else:
                if x == len(rows) - 1:
                    #print('Ultimo registro---------------')
                    idUltimo = rows[x][5]
                    rowsTotales = ejecutarQuery('SELECT totalsu,totalba,totalbl,totalot FROM totalespasaje')
                    cadena += '{},{},{},{}*'.format(rowsTotales[0][0], rowsTotales[0][1], rowsTotales[0][2], rowsTotales[0][3])
                    #print(cadena)
                    #comando = 'ST300UEX;907522797;01;010;20200218;17:41:56;2F100;+22.257101;-97.855511;000.012;000.00;9;1;0;15.30;001100;25;{};12;0;4.5;1'.format(cadena)
                    comando = cadena
                    deleteQr = 'DELETE FROM eventos WHERE id >= {} AND id <= {}'.format(idPrimero, idUltimo)
                    #if servidorDisponible():
                    comandosGPS.enviarGPS(0, comando, 0, deleteQr=deleteQr)
                cont += 1
            

    #else:
    #    print("No hay datos  para enviar")

def regCompletos(idEventos):
    row = ejecutarQuery('SELECT COUNT(id), MIN(id), MAX(id) FROM eventos')
    idEventos[0] = row[0][1]
    idEventos[1] = row[0][2]
    if row[0][0] >= 5:
        return True
    else:
        return False
"""
ret1, frame1 = cap1.read()
    cv2.rectangle(frame1,(0,450),(640,480),(254,109, 83),-1)
    font = cv2.FONT_ITALIC
    cv2.putText(frame1,"Fecha y Hora: 11/03/2020 11:30AM Categoria: INSEN", (150,469),font,0.5,(255,255,255),1,cv2.LINE_AA)
    img_name1 = "opencv_frame1_{}.png".format(img_counter)
    cv2.imwrite(img_name1, frame1)
"""
def capturarFoto(intentos, nomfoto, tipo, categoria, posicion):
    try:
        print("Capturando: " + str(nomfoto))
        
        if tipo == 0:
            pathfoto = os.getcwd() + "/fotos/barras/" + nomfoto
        if tipo == 1:
            pathfoto = os.getcwd() + "/fotos/boletos/" + nomfoto
        if tipo == 2:
            pathfoto = os.getcwd() + "/fotos/cortes/" + nomfoto
        if tipo == 3:
            pathfoto = os.getcwd() + "/fotos/solicitadas/" + nomfoto

        if posicion == 1:
            imagenesEspera1.append((pathfoto, categoria, posicion))
        if posicion == 2:
            imagenesEspera2.append((pathfoto, categoria, posicion))
        '''
        if posicion == 1: #camára delantera
            ret, frame = cap1.read()
            frame = cv2.resize(frame, (640, 480), interpolation=cv2.INTER_AREA)
            overlay = frame.copy()
            if not cap1.isOpened():
                raise Exception
        
        cv2.rectangle(frame,(0,450),(640,480),(254,109, 83),-1) #rectangulo Azul Sin Opacidad
        leyenda = obtenerfecha(2) + " Categoria: " + str(categoria) #Texto
        cv2.putText(frame,leyenda, (150,469),font,0.5,(255,255,255),1,cv2.LINE_AA) #Merge del Texto al Frame
        
        alpha = 0.4
        
        nuevoFrame = cv2.addWeighted(overlay, alpha, frame, 1 - alpha, 0) #Nuevo Frame con el Frame del rectangulo
        
        cv2.imwrite(pathfoto, nuevoFrame) #Crea el archivo
        '''
    except:
        print("Camara Ocupada: " + nomfoto)
        intentos += 1
        if intentos < 5:
            tcapturarFoto = Thread(target=capturarFoto, args=(intentos,nomfoto,tipo, categoria, posicion))
            tcapturarFoto.start()
        else:
            print("Error en la captura de la foto.")

def actualizar(cc, nomfoto) :
    fecha = obtenerfecha(0)
    posicion = 0
    duracion = 0
    
    if cc[0:1] == "1":
        posicion = 1
    if cc[0:1] == "2":
        posicion = 2

    if cc == "1SU" or cc == "2SU":
        tipoEvento = 1
        ejecutarQuery('UPDATE totalespasaje SET totalsu = totalsu + 1 WHERE id = 1')
    if cc == "1BA" or cc == "2BA":
        tipoEvento = 2
        ejecutarQuery('UPDATE totalespasaje SET totalba = totalba + 1 WHERE id = 1')
    if cc == "1OT" or cc == "2OT":
        tipoEvento = 4
        ejecutarQuery('UPDATE totalespasaje SET totalot = totalot + 1 WHERE id = 1')
    if cc[0:4] == "1BLF" or cc[0:4] == "2BLF":
        tipoEvento = 3
        duracion = int(cc[4:])
        ejecutarQuery('UPDATE totalespasaje SET totalbl = totalbl + 1 WHERE id = 1')
    
    queryEvento = 'INSERT INTO eventos (tipoEvento, fecha, duracion, posicion, foto) VALUES(?,?,?,?,?)'
    queryBarrasCorte = 'INSERT INTO barrascorte (tipoEvento, fecha, duracion, posicion, foto) VALUES(?,?,?,?,?)'
    datos = (tipoEvento, fecha, duracion, posicion, nomfoto)
    ejecutarQuery(queryEvento, datos)
    ejecutarQuery(queryBarrasCorte, datos)
    
def obtenerfecha(t):
    if t == 0:
        return datetime.now().strftime("%y%m%d%H%M%S%f")
    if t == 1:
        return datetime.now().strftime("%d/%m/%Y")
    if t == 2:
        return datetime.now().strftime("%d/%m/%Y %H:%M:%S")
    if t == 3:
        return datetime.now().strftime("%y%m%d%H%M%S")
    if t == 4:
        return datetime.now().strftime("%d_%m_%Y")
    if t == 5:#Retorna fecha de ayer. 
        return (datetime.now() - timedelta(1)).strftime('%d_%m_%Y')
    
def imprimirboleto(intento, tipoBoleto, precio, tipo, nomfoto, folioTicket):
    #print("Imprimiendo...")
    fecha = obtenerfecha(0)
    folio = None
    if intento == 0:
        if tipo == 1:
            ejecutarQuery('UPDATE totalespasaje SET totaladultos = totaladultos + 1 WHERE id = 1')
            folio = ejecutarQuery('SELECT totaladultos FROM totalespasaje')
        if tipo == 2:
            ejecutarQuery('UPDATE totalespasaje SET totalestudiantes = totalestudiantes + 1 WHERE id = 1')
            folio = ejecutarQuery('SELECT totalestudiantes FROM totalespasaje')
        if tipo == 3:
            ejecutarQuery('UPDATE totalespasaje SET totalinsen = totalinsen + 1 WHERE id = 1')
            folio = ejecutarQuery('SELECT totalinsen FROM totalespasaje')
        if tipo == 4:
            ejecutarQuery('UPDATE totalespasaje SET totalotro = totalotro + 1 WHERE id = 1')
            folio = ejecutarQuery('SELECT totalotro FROM totalespasaje')
        folioTicket = folio[0][0]
    foliotckt = str(tipoBoleto) + str(folioTicket)
    folioBoleto = str(tipoBoleto) + str('{:0>5d}'.format(folioTicket))
    #boleto = "Ruta: 22 - Tampico Borreguera \nPrecio:\$"+str(precio)+"    "+obtenerfecha(2)+"\nFolio: "+ str(folioBoleto) + "\n\nEste boleto cubre su seguro de  pasajero.\n\n\n\n"
    boleto = "Ruta: " + comandosGPS.nombreRuta + " \n"+obtenerfecha(2)+"\nFolio: "+ str(folioBoleto) + "\nPrecio:\$" + str(precio)+"\n\nEste boleto cubre su seguro de  pasajero.\n\n\n\n"
    
    sbps = subprocess.Popen("sudo echo -e \""+str(boleto)+"\" > /dev/usb/lp0", shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    err = sbps.stderr.read().decode()
    
    if err != "":
        print("impresora ocupada")
        time.sleep(0.50)
        intento += 1
        if intento < 5:
            print("Reintentando imprimir (" + str(intento) + ") ...")
            r = Thread(target=imprimirboleto, args=(intento, tipoBoleto, precio, tipo, nomfoto, folioTicket))
            r.start()
        else:
            print("Error al imprimir")
    if intento == 0:
        ejecutarQuery('INSERT INTO boletos (folio, fecha, tipo, foto) VALUES (?,?,?,?)', (foliotckt, fecha, tipo, nomfoto))
        ejecutarQuery('INSERT INTO bolcorte (folio, fecha, tipo, foto) VALUES (?,?,?,?)', (foliotckt, fecha, tipo, nomfoto))

def imprimirCorte(tipoCorte):
    datos = ejecutarQuery('SELECT * FROM bolcorte')
    
    corte = 'Ruta: ' + comandosGPS.nombreRuta + ' \n\n'
    if tipoCorte == 1:
        corte += 'Fecha corte: '
    if tipoCorte == 2:
        corte += 'Fecha revision: '
    corte += obtenerfecha(2) + '\n\n'
    corte += '           -Boletaje-'
    
    tipoBoleto = ''
    contAdulto = 0
    contEstudiante = 0
    contINSEN = 0
    for i in range(len(datos)):
        if datos[i][2] == '1':
            contAdulto += 1
        if datos[i][2] == '2':
            contEstudiante += 1
        if datos[i][2] == '3':
            contINSEN += 1
            
        #fechaBoleto = time.strptime(datos[i][1], '%y%m%d%H%M%S%f')
        #fechaBoleto = time.strftime('%d/%m/%Y %H:%M:%S', fechaBoleto)
    row = ejecutarQuery('SELECT precioAdulto, precioEstudiante, precioInsen from configuracion;')
    
    totalAdultos = float(row[0][0]) * contAdulto
    totalEstudiantes = float(row[0][1]) * contEstudiante
    totalINSEN = float(row[0][2]) * contINSEN
    
    corte += '\n\nTotal adultos: {} / \${}\n'.format(contAdulto, totalAdultos)
    corte += 'Total estudiantes: {} / \${}\n'.format(contEstudiante, totalEstudiantes)
    corte += 'Total INSEN: {} / \${}\n\n'.format(contINSEN, totalINSEN)
    
    total = totalAdultos + totalEstudiantes + totalINSEN
    cont = contAdulto + contEstudiante + contINSEN
    
    corte += 'Total: {} / \${}'.format(cont, total)
    
    datos = ejecutarQuery('SELECT * FROM barrascorte')

    su1 = 0
    ba1 = 0
    bl1 = 0
    ot1 = 0
    su2 = 0
    ba2 = 0
    bl2 = 0
    ot2 = 0

    for i in range(len(datos)):
        if datos[i][4] == 1:
            if datos[i][1] == 1:
                su1 += 1
            if datos[i][1] == 2:
                ba1 += 1
            if datos[i][1] == 3:
                bl1 += 1
            if datos[i][1] == 4:
                ot1 += 1
        if datos[i][4] == 2:
            if datos[i][1] == 1:
                su2 += 1
            if datos[i][1] == 2:
                ba2 += 1
            if datos[i][1] == 3:
                bl2 += 1
            if datos[i][1] == 4:
                ot2 += 1
    
    '''
    corte += '\n\n            -Barras-\n\n'
    corte += '-Delantera\n'
    corte += 'Subidas: {}\n'.format(su1)
    corte += 'Bajadas: {}\n'.format(ba1)
    corte += 'Bloqueos: {}\n'.format(bl1)
    corte += 'Otros: {}\n\n'.format(ot1)
    
    corte += '-Trasera\n'
    corte += 'Subidas: {}\n'.format(su2)
    corte += 'Bajadas: {}\n'.format(ba2)
    corte += 'Bloqueos: {}\n'.format(bl2)
    corte += 'Otros: {}\n\n'.format(ot2)
    
    corte += '-Totales\n'
    corte += 'Subidas: {}\n'.format(su1 + su2)
    corte += 'Bajadas: {}\n'.format(ba1 + ba2)
    corte += 'Bloqueos: {}\n'.format(bl1 + bl2)
    corte += 'Otros: {}\n'.format(ot1 + ot2)
    '''
    corte += '\n\n\n'
    sbps = subprocess.Popen("sudo echo -e \""+str(corte)+"\" > /dev/usb/lp0", shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    err = sbps.stderr.read().decode()

    comando = '|{},{},{}|{},{},{},{}|{},{},{},{}'.format(contAdulto, contEstudiante, contINSEN, su1, ba1, bl1, ot1, su2, ba2, bl2, ot2)
    
    return str(comando)

def realizarCorte():
    flagPressed = True
    startPressed = time.time()
    beep = True
    while flagPressed:
        endPressed = time.time()
        if not btn26.is_pressed:
            flagPressed = False
        else:
            tiempoTranscurrido = endPressed - startPressed
            if tiempoTranscurrido > 2:
                if beep:
                    buzzer.beep(0.5, 0.5, 3, True)
                    beep = False
    
    tiempoTranscurrido = endPressed - startPressed
    
    print(tiempoTranscurrido)
    
    nomfoto = obtenerfecha(0) + '.png'

    print('Evaluando tiempo')
    tipoCorte = 0
    categoria = ''
    if tiempoTranscurrido < 2:
        tipoCorte = 2
        categoria = 'Revision'
        print('Menos de dos segundos')
    else:
        tipoCorte = 1
        categoria = 'Corte'
        
    
        
    tcapturarFoto = Thread(target=capturarFoto, args=(0, nomfoto, 2, categoria, 1))
    tcapturarFoto.start()
    
    comando = '$|{},{}'.format(obtenerfecha(3), tipoCorte)
    comandoCant = imprimirCorte(tipoCorte)
    comando += str(comandoCant) + str('|{}*'.format(nomfoto))

    if tipoCorte == 1:
        comandosGPS.enviarGPS(0, comando, 2, deleteQr='DELETE FROM barrascorte', deleteQr2='DELETE FROM bolcorte')
    elif tipoCorte == 2:
        print(comando)
        comandosGPS.enviarGPS(0, comando, 2)

    '''
    print('Printing...26: Otro \n\n')
    #timprimirBoleto = Thread(target=imprimirboleto)
    fecha = obtenerfecha(0)
    nomfoto = fecha + str(".png")
    tcapturarFoto = Thread(target=capturarFoto, args=(0, nomfoto, 1,"Otro", 1))
    tcapturarFoto.start()
    timprimirBoleto = Thread(target=imprimirboleto, args=(0, serieOtro, precioOtro, 4, nomfoto, ''))
    timprimirBoleto.start()
    '''
def boletoInsen():
    print('Printing...13: Insen\n\n')
    fecha = obtenerfecha(0)
    nomfoto = fecha + str(".png")
    tcapturarFoto = Thread(target=capturarFoto, args=(0,nomfoto,1, "Insen", 1))
    tcapturarFoto.start()
    timprimirBoleto = Thread(target=imprimirboleto, args=(0, comandosGPS.serieInsen, comandosGPS.precioInsen, 3, nomfoto, ''))
    timprimirBoleto.start()

def boletoEstudiante():
    print('Printing...19: Estudiante \n\n')
    fecha = obtenerfecha(0)
    nomfoto = fecha + str(".png")
    tcapturarFoto = Thread(target=capturarFoto, args=(0,nomfoto,1, "Estudiante", 1))
    tcapturarFoto.start()
    timprimirBoleto = Thread(target=imprimirboleto, args=(0, comandosGPS.serieEstudiante, comandosGPS.precioEstudiante, 2, nomfoto, ''))
    timprimirBoleto.start()
        
def boletoAdulto():
    print('Printing...6: Adulto\n\n')
    timprimirBoleto = Thread(target=imprimirboleto, args=(0, comandosGPS.serieAdulto, comandosGPS.precioAdulto, 1, '', ''))
    timprimirBoleto.start()

def camaraListener1():
    cap1 = cv2.VideoCapture(0)
    cap1.set(cv2.CAP_PROP_FRAME_WIDTH, 640)
    cap1.set(cv2.CAP_PROP_FRAME_HEIGHT, 480)
    
    while True:
        try:
            ret, frame = cap1.read()
        except:
            raise

        if len(imagenesEspera1) > 0:
            try:
                datosFoto = imagenesEspera1.pop(0)
                frame = cv2.resize(frame, (640, 480), interpolation=cv2.INTER_AREA)
                overlay = frame.copy()
                
                font = cv2.FONT_ITALIC

                cv2.rectangle(frame,(0,450),(640,480),(254,109, 83),-1) #rectangulo Azul Sin Opacidad
                leyenda = obtenerfecha(2) + " Categoria: " + str(datosFoto[1]) #Texto
                cv2.putText(frame,leyenda, (150,469),font,0.5,(255,255,255),1,cv2.LINE_AA) #Merge del Texto al Frame
                
                alpha = 0.4
                
                nuevoFrame = cv2.addWeighted(overlay, alpha, frame, 1 - alpha, 0) #Nuevo Frame con el Frame del rectangulo
                
                cv2.imwrite(datosFoto[0], nuevoFrame) #Crea el archivo
            except Exception as e:
                print('Error al tomar foto: {}'.format(e))
                
def camaraListener2():
    cap2 = cv2.VideoCapture(2)
    cap2.set(cv2.CAP_PROP_FRAME_WIDTH, 640)
    cap2.set(cv2.CAP_PROP_FRAME_HEIGHT, 480)
    
    while True:
        try:
            ret, frame = cap2.read()
        except:
            raise

        if len(imagenesEspera2) > 0:
            try:
                datosFoto = imagenesEspera2.pop(0)
                frame = cv2.resize(frame, (640, 480), interpolation=cv2.INTER_AREA)
                overlay = frame.copy()
                
                font = cv2.FONT_ITALIC

                cv2.rectangle(frame,(0,450),(640,480),(254,109, 83),-1) #rectangulo Azul Sin Opacidad
                leyenda = obtenerfecha(2) + " Categoria: " + str(datosFoto[1]) #Texto
                cv2.putText(frame,leyenda, (150,469),font,0.5,(255,255,255),1,cv2.LINE_AA) #Merge del Texto al Frame
                
                alpha = 0.4
                
                nuevoFrame = cv2.addWeighted(overlay, alpha, frame, 1 - alpha, 0) #Nuevo Frame con el Frame del rectangulo
                
                cv2.imwrite(datosFoto[0], nuevoFrame) #Crea el archivo
            except Exception as e:
                print('Error al tomar foto: {}'.format(e))

'''
def camaraListener():
    cap1 = cv2.VideoCapture(0)
    cap1.set(cv2.CAP_PROP_FRAME_WIDTH, 640)
    cap1.set(cv2.CAP_PROP_FRAME_HEIGHT, 480)
    cap2 = cv2.VideoCapture(2)
    cap2.set(cv2.CAP_PROP_FRAME_WIDTH, 640)
    cap2.set(cv2.CAP_PROP_FRAME_HEIGHT, 480)
    
    while True:
        try:
            ret1, frame1 = cap1.read()
            cv2.imshow('camara1', frame1)
            
            if cv2.waitKey(1) & 0xFF == ord('q'):
                break
        except:
            raise
        try:
            ret2, frame2 = cap2.read()
        except:
            raise

        if len(imagenesEspera) > 0:
            try:
                datosFoto = imagenesEspera.pop(0)
                if datosFoto[2] == 1: #camára delantera
                    ret, frame = cap1.read()
                if datosFoto[2] == 2:
                    ret, frame = cap2.read()
                frame = cv2.resize(frame, (640, 480), interpolation=cv2.INTER_AREA)
                overlay = frame.copy()
                
                font = cv2.FONT_ITALIC

                cv2.rectangle(frame,(0,450),(640,480),(254,109, 83),-1) #rectangulo Azul Sin Opacidad
                leyenda = obtenerfecha(2) + " Categoria: " + str(datosFoto[1]) #Texto
                cv2.putText(frame,leyenda, (150,469),font,0.5,(255,255,255),1,cv2.LINE_AA) #Merge del Texto al Frame
                
                alpha = 0.4
                
                nuevoFrame = cv2.addWeighted(overlay, alpha, frame, 1 - alpha, 0) #Nuevo Frame con el Frame del rectangulo
                
                cv2.imwrite(datosFoto[0], nuevoFrame) #Crea el archivo
            except Exception as e:
                print('Error al tomar foto: {}'.format(e))
'''
t = Thread(target=camaraListener1)
t.start()

t = Thread(target=camaraListener2)
t.start()

t = Timer(30.0, vaciarTabla, (True,[0,0]))
t.start()

t_wifi = Timer(30.0, verificarWifi)
t_wifi.start()

t_enviarTCPBoletos = Timer(1.0, enviarTCPBoletos, (True,))
t_enviarTCPBoletos.start()

try:
    ser1 = serial.Serial(puerto_serial_ard1, baud_rate) #raspbian ls /dev/tty*
except:
    print('Error al leer serial')

try:
    ser2 = serial.Serial(puerto_serial_ard2, baud_rate)
except:
    print('Error al leer serial')

print("Iniciando Sistema 2.6")

comandoInicio = '!|02'
comandosGPS.enviarGPS(0, comandoInicio, 3)

btn6.when_released = boletoAdulto
btn13.when_released = boletoEstudiante
btn19.when_released = boletoInsen
btn26.when_pressed = realizarCorte
buzzer.beep(0.1,0.1,2,True)

def listenbarras(ser, puerto_serial):
    subidas_1 = 0
    bajadas_1 = 0
    bloqueos_1 = 0
    otros_1 = 0

    subidas_2 = 0
    bajadas_2 = 0
    bloqueos_2 = 0
    otros_2 = 0

    nomfoto = ''
    nomFotoBloqueo_1 = ''
    nomFotoBloqueo_2 = ''
    nomFoto2IniSubida = ''
    
    while True:
        try:
            #cc=str(ser.readline().decode())
            cc=str(ser.readline())
        except serial.SerialException:
            print("Error al leer el serial")
            try:
                ser = serial.Serial(puerto_serial, baud_rate)
                cc=str(ser.readline())
            except serial.SerialException:
                continue
        cc= (cc[2:][:-5])
        #print(str(cc) + str(len(cc)))
        #Escribir en archivo print(cc) fecha y cc
        t = Thread(target=escribirLog, args=(cc,))
        t.start()
        
        if cc != "":
            #print(cc)
            if cc == "1Ini":
                nomfoto = ""
                subidas_1 = 0
                bajadas_1 = 0
                bloqueos_1 = 0
                otros = 0
            if cc == "1SU":
                nomfoto = ""
                subidas_1 += 1
            if cc == "1BA":
                nomfoto = ""
                bajadas_1 += 1
            if cc == "1OT":
                otros_1 += 1
                nomfoto = obtenerfecha(0) + str(".png")
                tcapturarFoto = Thread(target=capturarFoto, args=(0,nomfoto,0,"Otro", 1))
                tcapturarFoto.start()
            if cc[0:4] == "1BLF" : #BLF3000
                print("Bloqueado por: " + str( cc[4:] ) + " ms")
                nomfoto = nomFotoBloqueo_1
            if cc == "1BL":
                bloqueos_1 += 1
                nomfoto = obtenerfecha(0) + str(".png")
                nomFotoBloqueo_1 = nomfoto
                tcapturarFotobl = Thread(target=capturarFoto, args=(0,nomfoto,0,"Bloqueo", 1))
                tcapturarFotobl.start()

            if cc == '2ISU':
                nomfoto = obtenerfecha(0) + str('.png')
                nomFoto2IniSubida = nomfoto
                tcapturarFoto2ISU = Thread(target=capturarFoto, args=(0,nomfoto,0,"Subida", 2))
                tcapturarFoto2ISU.start()

            if cc == "2Ini":
                nomfoto = ""
                subidas_2 = 0
                bajadas_2 = 0
                bloqueos_2 = 0
                otros_2 = 0
            if cc == "2SU":
                print("\n" + str(cc) + "\n")
                nomfoto = nomFoto2IniSubida
                subidas_2 += 1
            if cc == "2BA":
                print("\n" + str(cc) + "\n")
                nomfoto = ""
                bajadas_2 += 1
            if cc == "2OT":
                otros_2 += 1
                nomfoto = obtenerfecha(0) + str(".png")
                tcapturarFoto = Thread(target=capturarFoto, args=(0,nomfoto,0,"Otro", 2))
                tcapturarFoto.start()
            if cc[0:4] == "2BLF" : #BLF3000
                print("Bloqueado por: " + str( cc[4:] ) + " ms")
                nomfoto = nomFotoBloqueo_2

            if cc == "2BL":
                bloqueos_2 += 1
                nomfoto = obtenerfecha(0) + str(".png")
                nomFotoBloqueo_2 = nomfoto
                tcapturarFotobl = Thread(target=capturarFoto, args=(0,nomfoto,0,"Bloqueo", 2))
                tcapturarFotobl.start()
            if cc == "1SU" or cc == "1BA" or cc == "1BL" or cc == "1Ini" or cc == "1OT":
                #os.system("cls")
                print("Subidas 1: " + str(subidas_1) + "\nBajadas 1: " + str(bajadas_1) + "\nBloqueos 1: " + str(bloqueos_1) + "\nOtros 1: " + str(otros_1))
            if cc == "2SU" or cc == "2BA" or cc == "2BL" or cc == "2Ini" or cc == "2OT":
                #os.system("cls")
                print("Subidas 2: " + str(subidas_2) + "\nBajadas 2: " + str(bajadas_2) + "\nBloqueos 2: " + str(bloqueos_2) + "\nOtros 2: " + str(otros_2))
            if cc == "1SU" or cc == "1BA" or cc[0:4] == "1BLF" or cc == "1OT" or cc == "2SU" or cc == "2BA" or cc[0:4] == "2BLF" or cc == "2OT":
                tipoEvento = 0
                duracion = 0
                tupdate = Thread(target=actualizar, args=(cc, nomfoto))
                tupdate.start()

                idEventos = [0, 0]
                if regCompletos(idEventos):
                    t = Thread(target=vaciarTabla, args=(False, idEventos))
                    t.start()
        
tBarra1 = Thread(target=listenbarras, args=(ser1, puerto_serial_ard1))
tBarra1.start()

tBarra2 = Thread(target=listenbarras, args=(ser2, puerto_serial_ard2))
tBarra2.start()

tGPS = Thread(target=comandosGPS.escuchaGPS, args=(ser,))
tGPS.start()

tGPS = Thread(target=comandosGPS.escuchaControlador)
tGPS.start()
